#============================================================================== 
# ** Ruby.Array.list
#------------------------------------------------------------------------------
# Description:
# ------------
# Methods created that treats an array as a list.
#  
# Method List:
# ------------
# random
# random!
# rate
# series_string
# sort_by!
# unsort
#==============================================================================

MACL::Loaded << 'Ruby.Array.list'

#============================================================================== 
# ** Array     
#==============================================================================

class Array
  #-------------------------------------------------------------------------
  #   Name      : Random
  #   Info      : Returns a Random element in the array
  #   Author    : SephirothSpawn
  #   Call Info : No Arguments
  #-------------------------------------------------------------------------
  def random
    return self[rand(size)]
  end
  #-------------------------------------------------------------------------
  #   Name      : Random!
  #   Info      : Returns and Deletes a Random element in the array
  #   Author    : Trickster
  #   Call Info : No Arguments
  #-------------------------------------------------------------------------
  def random!
    return delete_at(rand(size))
  end
  #-------------------------------------------------------------------------
  #   Name      : Rate
  #   Info      : Rates all indexes from least(0) to greatest(size-1)
  #   Author    : Trickster
  #   Call Info : Zero or One Arguemtns Boolean Same (Defaults to true)
  #              If same is true then rating increases for same values in the 
  #              array
  #-------------------------------------------------------------------------
  def rate(same = true)
    # Create Rated Array
    rated = []
    # Create A Copy of the Array
    copy = self.dup
    # Initialize rate
    rate = 1
    # Run Through Size number of times
    size.times do
      # For each index where minimum is found
      copy.find_index(copy.compact.min).each do |index|
        # Set Rated at index to rating
        rated[index] = rate
        # Set Copy at index to nil
        copy[index] = nil
        # Increase Rating if false sent (increase for same)
        rate += 1 if !same
      end
      # Increase Rating if same is true (don't increase for same valued)
      rate += 1 if same
      # Break if no more non nil items
      break if copy.nitems == 0
    end
    # Return Rated Array
    return rated
  end
  #-------------------------------------------------------------------------
  # * Name      : Series String
  #   Info      : Returns a String with a list of the objects in the array
  #   Author    : Trickster
  #   Call Info : No Arguments
  #-------------------------------------------------------------------------
  def series_string
    # Setup String
    series = ''
    # If Size is 1
    if size == 1
      # Set Series to First
      series = self[0].to_s
    elsif size == 2
      # Set Battlers to battler and battler
      series = self[0].to_s + ' and ' + self[1].to_s
    else
      # Run Through Each Item with index
      each_with_index do |string, index|
        # Add String to Series
        series += string.to_s
        # Add , if not at last entry
        series += ', ' if index <= size - 2
        # Add and if at last entry
        series += 'and ' if index == size - 2
      end
    end
    return series
  end
  #-------------------------------------------------------------------------
  #   Name      : Sort By!
  #   Info      : Modifies Itself, Performs sort_by on the array
  #   Author    : Trickster
  #   Call Info : A Block
  #   Comment   : See Enumerable#sort_by
  #-------------------------------------------------------------------------
  def sort_by!(&block)
    # Duplicate Array
    saved = self.dup
    # Sort Array Call Block Sent
    sorted = sort_by {|object| block.call(object)}
    # Modify Original Array
    sorted.each_with_index {|item, index| self[index] = item}
    # If Changes Made Return self else nil
    return (saved == self ? nil : self)
  end
  #-------------------------------------------------------------------------
  # * Name      : self.unsort
  #   Info      : return a array of mixed elements
  #   Author    : Hanmac
  #   Call Info :  with min one Argument from type can this be everything
  #-------------------------------------------------------------------------
  def self.unsort(*arrays)
    array = arrays.flatten
    Array.new(array.size) {
      zufall = rand(array.size)
      array.delete_at(zufall)
    }
  end
end

